/**
 * \file: feature_db.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: authorization level daemon
 *
 * \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
 *
 * \copyright (c) 2010, 2011 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/
#ifndef ALD_INIT_FEATURE_DB_H
#define ALD_INIT_FEATURE_DB_H

#include <stdio.h>

#include "model/level_configuration.h"
#include "ald_types.h"

//--------------------------------------- functions for loading feature info and checking for script completeness -----

error_code_t feature_db_load(const char *root_dir, const char *sysroot_dir);

void feature_db_free(void);

//--------------------------------------- functions for checking feature completeness in level files -----------------

error_code_t feature_db_check_level_for_feature_completeness(level_configuration_t *level_conf);

//--------------------------------------- functions for filling the signature db with feature script signatures ------

error_code_t feature_db_fill_signature_db(const char *root_dir);

#endif
